/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.fund.UmpayAccountBalanceQueryRequest;
import com.fshows.umpay.sdk.request.fund.UmpayAccountInvestQueryRequest;
import com.fshows.umpay.sdk.request.fund.UmpayCounterofferBillDownloadRequest;
import com.fshows.umpay.sdk.request.fund.UmpayDrawApplyOpenRequest;
import com.fshows.umpay.sdk.request.fund.UmpayDrawApplyRequest;
import com.fshows.umpay.sdk.request.fund.UmpayDrawResultQueryRequest;
import com.fshows.umpay.sdk.request.fund.UmpayMerchantBalanceQueryRequest;
import com.fshows.umpay.sdk.request.fund.UmpayMerchantStopRemitRequest;
import com.fshows.umpay.sdk.request.fund.UmpaySettlementQueryRequest;
import com.fshows.umpay.sdk.request.fund.UmpayTradeBillDownloadRequest;
import com.fshows.umpay.sdk.response.fund.UmpayAccountBalanceQueryResponse;
import com.fshows.umpay.sdk.response.fund.UmpayAccountInvestQueryResponse;
import com.fshows.umpay.sdk.response.fund.UmpayCounterofferBillDownloadResponse;
import com.fshows.umpay.sdk.response.fund.UmpayDrawApplyOpenResponse;
import com.fshows.umpay.sdk.response.fund.UmpayDrawApplyResponse;
import com.fshows.umpay.sdk.response.fund.UmpayDrawResultQueryResponse;
import com.fshows.umpay.sdk.response.fund.UmpayMerchantBalanceQueryResponse;
import com.fshows.umpay.sdk.response.fund.UmpayMerchantStopRemitResponse;
import com.fshows.umpay.sdk.response.fund.UmpaySettlementQueryListResponse;
import com.fshows.umpay.sdk.response.fund.UmpayTradeBillDownloadResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * 提现/结算/资金相关API枚举
 *
 * @author youmingming
 * @version UmMerchantApiEnum.java, v 0.1 2022-02-09 下午10:41 youmingming
 */
public enum UmFundApiEnum implements UmpayApiDefinition {

    MERCHANT_BALANCE_QUERY(
            "商户余额查询",
            "liquidation.draw.balance.query",
            UmpayMerchantBalanceQueryRequest.class,
            UmpayMerchantBalanceQueryResponse.class
    ),
    SETTLEMENT_QUERY(
            "结算结果查询",
            "aggregation.settlement.query",
            UmpaySettlementQueryRequest.class,
            UmpaySettlementQueryListResponse.class
    ),
    DRAW_APPLY_OPEN(
            "提现权限开通",
            "liquidation.draw.apply.open",
            UmpayDrawApplyOpenRequest.class,
            UmpayDrawApplyOpenResponse.class
    ),
    DRAW_APPLY(
            "发起提现申请",
            "liquidation.draw.apply",
            UmpayDrawApplyRequest.class,
            UmpayDrawApplyResponse.class
    ),
    DRAW_RESULT_QUERY(
            "提现结果查询",
            "liquidation.draw.result.query",
            UmpayDrawResultQueryRequest.class,
            UmpayDrawResultQueryResponse.class
    ),
    TRADE_BILL_DOWNLOAD(
            "交易明细账单",
            "liquidation.finance.downloadbill",
            UmpayTradeBillDownloadRequest.class,
            UmpayTradeBillDownloadResponse.class
    ),
    COUNTEROFFER_BILL_DOWNLOAD(
            "提现出款账单",
            "liquidation.counteroffer.file.push",
            UmpayCounterofferBillDownloadRequest.class,
            UmpayCounterofferBillDownloadResponse.class
    ),
    MERCHANT_STOP_REMIT(
            "商户止付接口（冻结出款）",
            "aggregation.merchant.switch",
            UmpayMerchantStopRemitRequest.class,
            UmpayMerchantStopRemitResponse.class
    ),
    MERCHANT_ACCOUNT_BALANCE_QUERY(
            "服务商账户余额查询",
            "liquidation.account.balance.query",
            UmpayAccountBalanceQueryRequest.class,
            UmpayAccountBalanceQueryResponse.class
    ),
    MERCHANT_ACCOUNT_INVEST_QUERY(
            "服务商账户充值记录查询",
            "liquidation.account.invest.query",
            UmpayAccountInvestQueryRequest.class,
            UmpayAccountInvestQueryResponse.class
    )

    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmFundApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmFundApiEnum getByValue(String value) {
        UmFundApiEnum[] valueList = UmFundApiEnum.values();
        for (UmFundApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}