/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.request.activity.UmpayAlipayActivityApplyRequest;
import com.fshows.umpay.sdk.request.activity.UmpayAlipayActivityQueryRequest;
import com.fshows.umpay.sdk.request.activity.UmpayWxActivityApplyRequest;
import com.fshows.umpay.sdk.request.activity.UmpayWxActivityQueryRequest;
import com.fshows.umpay.sdk.response.activity.UmpayAlipayActivityApplyResponse;
import com.fshows.umpay.sdk.response.activity.UmpayAlipayActivityQueryResponse;
import com.fshows.umpay.sdk.response.activity.UmpayWxActivityApplyResponse;
import com.fshows.umpay.sdk.response.activity.UmpayWxActivityQueryResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * 活动API枚举
 *
 * @author youmingming
 * @version UmMerchantApiEnum.java, v 0.1 2022-02-09 下午10:41 youmingming
 */
public enum UmActivityApiEnum implements UmpayApiDefinition {

    ALIPAY_ACTIVITY_APPLY(
            "支付宝活动报名接口",
            "liquidation.alipay.activity.apply",
            UmpayAlipayActivityApplyRequest.class,
            UmpayAlipayActivityApplyResponse.class
    ),
    ALIPAY_ACTIVITY_QUERY(
            "支付宝活动审核状态查询接口",
            "liquidation.alipay.activity.query",
            UmpayAlipayActivityQueryRequest.class,
            UmpayAlipayActivityQueryResponse.class
    ),
    WX_ACTIVITY_APPLY(
            "微信活动报名接口",
            "liquidation.wx.activity.apply",
            UmpayWxActivityApplyRequest.class,
            UmpayWxActivityApplyResponse.class
    ),
    WX_ACTIVITY_QUERY(
            "微信活动审核状态查询接口",
            "liquidation.wx.activity.query",
            UmpayWxActivityQueryRequest.class,
            UmpayWxActivityQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口方法签名
     */
    private String value;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    UmActivityApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static UmActivityApiEnum getByValue(String value) {
        UmActivityApiEnum[] valueList = UmActivityApiEnum.values();
        for (UmActivityApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    /**
     * Getter method for property <tt>requestClass</tt>.
     *
     * @return property value of requestClass
     */
    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return this.responseClass;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}