/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.response.merchant;

import lombok.Data;

import java.io.Serializable;

/**
 * 个人用户进件响应结果
 *
 * @author liluqing
 * @version UmBankPersonalEntryResponse.java, v 0.1 2023-04-07 10:24
 */
@Data
public class UmBankPersonalEntryResponse implements Serializable {

    /**
     * 商户编号
     */
    private String merId;

    /**
     * 商户订单号
     */
    private String orderId;

    /**
     * 订单时间 格式：yyyyMMdd
     */
    private String orderDate;

    /**
     * 进件申请单状态：
     * 1：鉴权成功
     * 2：鉴权失败
     * 3：电子签约中
     * 4：电子签约失败
     */
    private String orderState;

    /**
     * 失败原因
     */
    private String auditMsg;
}