/*
 * fshows.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.umpay.bankchannel.response.merchant;

import lombok.Data;

/**
 * @author FanJingchen
 * @version UmBankPersonalEntryQueryResponse.java, v 0.1 2023-05-16 14:13 FanJingchen
 */
@Data
public class UmBankPersonalEntryQueryResponse {
    /**
     * 商户订单号
     */
    private String orderId;
    /**
     * 商户订单时间
     */
    private String orderDate;

    /**
     * 订单状态
     * 0：创建（可以认为进件失败，流程中断）
     * 6：资料校验中
     * 7：待账户验证 (四要素鉴权)
     * 8：审核中
     * 9：处理中
     * 10：已通过
     * 11：进件失败
     * 12: 未知（可以认为进件失败）
     */
    private String orderState;

    /**
     * 失败原因
     */
    private String auditMsg;

}
