package com.fshows.umpay.bankchannel.response.funds;

import lombok.Data;

/**
 * @author liangyuanping
 * @version BankTransferResponse.java, v 0.1 2023-04-06 7:23 PM
 */
@Data
public class UmBankTransferResponse {
    /**
     * 商户订单号
     */
    private String orderId;
    /**
     * 订单时间 格式：yyyyMMdd
     */
    private String orderDate;
    /**
     * 交易状态.
     * 0-创建，1-成功，2-失败，3-处理中
     */
    private String status;
    /**
     * 商户支付流水，必须唯一，同一笔订单跟第一步申请保持一致。
     */
    private String merTrace;
    /**
     * 对账日期，格式：YYYYMMDD
     * 提现成功时返回
     */
    private String merCheckDate;
    /**
     * 联动订单号
     */
    private String tradeNo;
}