package com.fshows.umpay.bankchannel.response.funds;

import lombok.Data;

/**
 * @author liangyuanping
 * @version BankTransferQueryResponse.java, v 0.1 2023-04-06 7:29 PM
 */
@Data
public class UmBankTransferQueryResponse {

    /**
     * 商户订单号
     */
    private String orderId;
    /**
     * 订单时间 格式：yyyyMMdd
     */
    private String orderDate;
    /**
     * 交易状态.
     * 0-创建，1-成功，2-失败，3-处理中
     */
    private String status;
    /**
     * 商户支付流水，必须唯一，同一笔订单跟第一步申请保持一致。
     */
    private String merTrace;
    /**
     * 对账日期，格式：YYYYMMDD
     * 提现成功时返回
     */
    private String merCheckDate;
    /**
     * 联动订单号
     */
    private String tradeNo;
    /**
     * 备注信息
     */
    private String remark;
    /**
     * 失败原因 失败时有值
     */
    private String reason;

}