/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.request.merchant.item;

import com.fshows.umpay.annotation.EncryptField;
import com.fshows.umpay.bankchannel.request.UmBankBizItemRequest;
import lombok.Data;

/**
 * 组织机构代码证
 *
 * @author liluqing
 * @version UmBankEnterpriseLicenseRequest.java, v 0.1 2023-04-07 10:39
 */
@Data
public class UmBankBankCardRequest extends UmBankBizItemRequest {

    /**
     * 银行卡账户类型 1-对私账户，2-对公账户
     */
    private String bankcardType;
    /**
     * 银行卡卡号
     */
    @EncryptField
    private String bankAccount;
    /**
     * 开户名称
     */
    @EncryptField
    private String bankAccountName;
    /**
     * 银行编号
     */
    private String bankCode;
    /**
     * 联行号 对公必传
     */
    private String cnapsCode;
}