/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.request.merchant;

import com.fshows.umpay.annotation.EncryptField;
import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.merchant.UmBankPersonalEntryResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * 个人进件
 *
 * @author liluqing
 * @version UmBankPersonalEntryRequest.java, v 0.1 2023-04-07 10:23
 */
@Data
public class UmBankPersonalModifyRequest extends UmBankBizRequest<UmBankPersonalEntryResponse> implements Serializable {

    /**
     * 商户订单号
     */
    private String orderId;
    /**
     * 商户订单时间
     */
    private String orderDate;
    /**
     * 给用户分配的唯一编号
     */
    private String merCustId;
    /**
     * 用户姓名
     */
    @EncryptField
    private String name;
    /**
     * 身份证号
     */
    @EncryptField
    private String idCard;
    /**
     * 手机号
     */
    @EncryptField
    private String mobile;
    /**
     * 身份证正面图片media_id
     */
    private String idCardFrontMediaId;
    /**
     * 身份证反面图片media_id
     */
    private String idCardBackMediaId;
    /**
     * 证件有效期
     */
    private String idCardValidDate;
    /**
     * 银行卡卡号
     */
    @EncryptField
    private String bankAccount;
    /**
     * 开户名称
     */
    @EncryptField
    private String bankAccountName;
    /**
     * 银行编码
     */
    private String bankCode;
    /**
     * 联行号
     */
    private String cnapsCode;

    @Override
    public Class<UmBankPersonalEntryResponse> getResponseClass() {
        return UmBankPersonalEntryResponse.class;
    }
}