/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.request.merchant;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.merchant.UmBankEntryQueryResponse;
import com.google.gson.annotations.SerializedName;
import lombok.Data;

import java.io.Serializable;

/**
 * 进件状态查询
 *
 * @author liluqing
 * @version UmBankPersonalEntryRequest.java, v 0.1 2023-04-07 10:23
 */
@Data
public class UmBankEntryQueryRequest extends UmBankBizRequest<UmBankEntryQueryResponse> implements Serializable {

    /**
     * 商户订单号
     */
    @SerializedName("order_id")
    private String orderId;
    /**
     * 商户订单时间
     */
    @SerializedName("order_date")
    private String orderDate;

    @Override
    public Class<UmBankEntryQueryResponse> getResponseClass() {
        return UmBankEntryQueryResponse.class;
    }
}