/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.umpay.bankchannel.request.merchant;

import com.fshows.umpay.annotation.EncryptField;
import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.request.merchant.item.UmBankBankCardRequest;
import com.fshows.umpay.bankchannel.request.merchant.item.UmBankEnterpriseLicenseRequest;
import com.fshows.umpay.bankchannel.request.merchant.item.UmBankLegalPersonRequest;
import com.fshows.umpay.bankchannel.request.merchant.item.UmBankOrganizationCertRequest;
import com.fshows.umpay.bankchannel.request.merchant.item.UmBankTaxRegistrationCertRequest;
import com.fshows.umpay.bankchannel.response.merchant.UmBankEnterpriseEntryResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * 企业进件
 *
 * @author liluqing
 * @version UmBankPersonalEntryRequest.java, v 0.1 2023-04-07 10:23
 */
@Data
public class UmBankEnterpriseEntryRequest extends UmBankBizRequest<UmBankEnterpriseEntryResponse> implements Serializable {

    /**
     * 商户订单号
     */
    private String orderId;
    /**
     * 商户订单时间
     */
    private String orderDate;

    /**
     * 企业类型 2-个体，3-企业
     */
    private String orgType;
    /**
     * 商户简称
     */
    private String shortName;
    /**
     * 回调地址
     */
    private String notifyUrl;
    /**
     * 联系人邮箱 可以填法人邮箱
     */
    @EncryptField
    private String contactEmail;
    /**
     * 营业执照信息
     */
    @EncryptField
    private UmBankEnterpriseLicenseRequest license;
    /**
     * 组织机构代码证
     */
    private UmBankOrganizationCertRequest organizationCert;
    /**
     * 税务证
     */
    private UmBankTaxRegistrationCertRequest taxRegistrationCert;
    /**
     * 银行卡信息
     */
    @EncryptField
    private UmBankBankCardRequest bankcard;
    /**
     * 法人信息
     */
    @EncryptField
    private UmBankLegalPersonRequest legalPerson;

    @Override
    public Class<UmBankEnterpriseEntryResponse> getResponseClass() {
        return UmBankEnterpriseEntryResponse.class;
    }
}