package com.fshows.umpay.bankchannel.request.merchant;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.merchant.UmBankAccountQueryResponse;
import com.google.gson.annotations.SerializedName;
import lombok.Data;

import java.io.Serializable;

/**
 * @author liangyuanping
 * @version UmBankAccountQueryRequest.java, v 0.1 2023-04-07 3:44 PM
 */
@Data
public class UmBankAccountQueryRequest extends UmBankBizRequest<UmBankAccountQueryResponse> implements Serializable {

    /**
     * 给用户分配的唯一编号
     */
    @SerializedName("mer_cust_id")
    private String merCustId;
    /**
     * 电子账户号
     */
    @SerializedName("acct_id")
    private String acctId;

    @Override
    public Class<UmBankAccountQueryResponse> getResponseClass() {
        return UmBankAccountQueryResponse.class;
    }
}