package com.fshows.umpay.bankchannel.request.funds;

import com.fshows.umpay.annotation.EncryptField;
import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.funds.UmBankWithdrawalResponse;
import com.google.gson.annotations.SerializedName;
import lombok.Data;

@Data
public class UmBankWithdrawRequest extends UmBankBizRequest<UmBankWithdrawalResponse> {

    /**
     * 商户订单号	变长20	商户订单号支持数字、英文字母，其他字符不建议使用  长度4至20位  非空
     */
    @SerializedName("order_id")
    private String orderId;

    /**
     * 商户订单日期	定长8	商户生成订单的日期，格式YYYYMMDD  非空
     */
	@SerializedName("order_date")
	private String orderDate;

	/**
	 * 用户唯一编号 非空
	 */
	@SerializedName("mer_cust_id")
	private String merCustId;

	/**
	 * 电子账户号 非空
	 */
	@SerializedName("acct_id")
	private String acctId;

	/**
	 * 商户交易流水号 非空
	 */
	@SerializedName("mer_trace")
	private String merTrace;

	/**
	 * 银行卡号 需加密 非空
	 */
	@SerializedName("card_id")
	@EncryptField
	private String cardId;

	/**
	 * 提现金额	最少200000（2000元） 变长13 单位为分 非空
	 */
	@SerializedName("amount")
	private String amount;

	/**
	 * 备注信息	变长30
	 */
	@SerializedName("remark")
	protected String remark;

	/**
	 * 结果异步通知地址
	 */
	@SerializedName("notify_url")
	private String notifyUrl;

	@Override
	public Class<UmBankWithdrawalResponse> getResponseClass() {
		return UmBankWithdrawalResponse.class;
	}
}
