package com.fshows.umpay.bankchannel.request.funds;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.funds.UmBankTransferResponse;
import com.google.gson.annotations.SerializedName;
import lombok.Data;

/**
 * @author liangyuanping
 * @version BankTransferRequest.java, v 0.1 2023-04-06 7:22 PM
 */
@Data
public class UmBankTransferRequest extends UmBankBizRequest<UmBankTransferResponse> {
    /**
     * 用于接收异步通知地址的 URL
     * 选填
     */
    @SerializedName("notify_url")
    private String notifyUrl;
    /**
     * 商户订单号
     */
    @SerializedName("order_id")
    private String orderId;
    /**
     * 转账日期 YYYYMMDD
     */
    @SerializedName("order_date")
    private String orderDate;
    /**
     * 付款用户的电子账簿ID
     */
    @SerializedName("pay_acct_id")
    private String payAcctId;
    /**
     * 收款用户的电子账簿ID
     */
    @SerializedName("recv_acct_id")
    private String recvAcctId;
    /**
     * 商户支付流水，必须唯一
     */
    @SerializedName("mer_trace")
    private String merTrace;
    /**
     * 转账金额
     */
    @SerializedName("amount")
    private String amount;
    /**
     * 备注
     * 选填
     */
    @SerializedName("remark")
    private String remark;

    @Override
    public Class<UmBankTransferResponse> getResponseClass() {
        return UmBankTransferResponse.class;
    }
}