package com.fshows.umpay.bankchannel.request.funds;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.funds.UmBankTransferQueryResponse;
import com.google.gson.annotations.SerializedName;
import lombok.Data;

/**
 * @author liangyuanping
 * @version BankTransferQueryRequest.java, v 0.1 2023-04-06 7:29 PM
 */
@Data
public class UmBankTransferQueryRequest extends UmBankBizRequest<UmBankTransferQueryResponse> {

    /**
     * 给用户分配的唯一编号
     */
    @SerializedName("order_id")
    private String orderId;
    /**
     * 订单时间 格式：yyyyMMdd
     * 若填写order_id时，该字段必填
     * 未填写order_id时，该字段无效
     */
    @SerializedName("order_date")
    private String orderDate;

    @Override
    public Class<UmBankTransferQueryResponse> getResponseClass() {
        return UmBankTransferQueryResponse.class;
    }
}