package com.fshows.umpay.bankchannel.request.funds;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.funds.UmBankTradingQueryResponse;
import com.google.gson.annotations.SerializedName;
import lombok.Data;

/**
 * @author liangyuanping
 * @version UmBankTradingQueryRequest.java, v 0.1 2023-04-06 6:24 PM
 */
@Data
public class UmBankTradingQueryRequest extends UmBankBizRequest<UmBankTradingQueryResponse> {

    /**
     * 电子账户号
     */
    private String acctId;
    /**
     * 商户订单号
     */
    private String orderId;
    /**
     * 1-提现，2-转账，3-入金
     * 若填写order_id时，该字段必填
     * 未填写order_id时，该字段无效
     */
    private String busiType;
    /**
     * 开始时间，格式：YYYYMMDD
     */
    private String startDate;
    /**
     * 结束时间，格式：YYYYMMDD
     */
    private String endDate;
    /**
     * 游标，查下一页根据返回结果回填
     */
    private String cursor;
    /**
     * 每页条数，默认10
     */
    private String size;
    /**
     * 定长8
     * 订单时间 格式：yyyyMMdd
     * 若填写order_id时，该字段必填
     * 未填写order_id时，该字段无效
     */
    private String orderDate;

    @Override
    public Class<UmBankTradingQueryResponse> getResponseClass() {
        return UmBankTradingQueryResponse.class;
    }
}