package com.fshows.umpay.bankchannel.model.withdraw;

import com.fshows.umpay.bankchannel.model.res.WxhTradingQueryRes;
import com.fshows.umpay.bankchannel.model.res.WxhWithdrawQueryRes;
import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;

public class WxhWithdrawQuery extends MerchantBaseRequest {
	private String order_id;//	商户订单号	变长20	商户订单号支持数字、英文字母，其他字符不建议使用  长度4至20位   必填
	private String order_date;// 订单的日期，格式YYYYMMDD   必填

	private String url = "/wxh/withdrawal/orderQuery";


	@Override
	public String getRequestUrl() {
		return baseUrl + url;
	}

	@Override
	public WxhWithdrawQueryRes doRequest() throws Exception {
		UMFResponse.Message<WxhWithdrawQueryRes> response = UMFUtil.post(createAPIContext(), this, WxhWithdrawQueryRes.class);
		MerchantBaseRequest baseResult = convertResult(response, WxhTradingQueryRes.class);
		if (baseResult == null)
			return null;
		return (WxhWithdrawQueryRes) baseResult;
	}

	public String getOrder_id() {
		return order_id;
	}

	public void setOrder_id(String order_id) {
		this.order_id = order_id;
	}

	public String getOrder_date() {
		return order_date;
	}

	public void setOrder_date(String order_date) {
		this.order_date = order_date;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	@Override
	public String toString() {
		return "WithdrawQuery{" +
				"order_id='" + order_id + '\'' +
				", order_date='" + order_date + '\'' +
				", url='" + url + '\'' +
				", version='" + version + '\'' +
				", mer_id='" + mer_id + '\'' +
				", ret_code='" + ret_code + '\'' +
				", ret_msg='" + ret_msg + '\'' +
				", links=" + links +
				'}';
	}
}
