package com.fshows.umpay.bankchannel.model.transfer;

import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;
import lombok.Data;
import lombok.ToString;

/**
 * @author HEYUNHANG
 * @date 2023/3/28 16:04
 */
@ToString(callSuper = true)
@Data
public class TransferOrderQuery extends MerchantBaseRequest {


    private String order_id;

    private String order_date;


    //响应参数
    /*private String order_id;

    private String order_date;*/

    /**
     * 订单状态
     * 0-创建，1-成功，2-失败，3-处理中
     */
    private String status;

    /**
     * 失败原因
     */
    private String reason;

    /**
     * 备注
     */
    private String remark;


    private String url = "/wxh/transfer/transferOrderQuery";


    @Override
    public String getRequestUrl() {
        return baseUrl + url;
    }

    @Override
    public TransferOrderQuery doRequest() throws Exception {
        UMFResponse.Message<TransferOrderQuery> response = UMFUtil.post(createAPIContext(), this, TransferOrderQuery.class);
        MerchantBaseRequest baseResult = convertResult(response, TransferOrderQuery.class);
        if (baseResult == null)
            return null;
        return (TransferOrderQuery) baseResult;
    }
}
