package com.fshows.umpay.bankchannel.model.account;

import com.fshows.umpay.bankchannel.model.res.WxhTradingQueryRes;
import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;

public class WxhTradingQuery extends MerchantBaseRequest {
	private String acct_id;// 电子账户号 必填
	private String order_id;//	商户订单号	变长20	商户订单号支持数字、英文字母，其他字符不建议使用  长度4至20位
	private String order_date;// 订单的日期，格式YYYYMMDD   若填写order_id时，该字段必填   未填写order_id时，该字段无效
	private String busi_type;//1-提现，2-转账，3-入金 若填写order_id时，该字段必填   未填写order_id时，该字段无效
	private String start_date;//起始日期 YYYYMMDD 非必填
	private String end_date;//结束日期 YYYYMMDD  非必填
	private String cursor;//游标，根据查询结果回填查下一页 非必填
	private String size;//页码大小 默认10 非必填

	private String url = "/wxh/tradingQuery";


	@Override
	public String getRequestUrl() {
		return baseUrl + url;
	}

	@Override
	public WxhTradingQueryRes doRequest() throws Exception {
		UMFResponse.Message<WxhTradingQueryRes> response = UMFUtil.post(createAPIContext(), this, WxhTradingQueryRes.class);
		MerchantBaseRequest baseResult = convertResult(response, WxhTradingQueryRes.class);
		if (baseResult == null)
			return null;
		return (WxhTradingQueryRes) baseResult;
	}

	public String getAcct_id() {
		return acct_id;
	}

	public void setAcct_id(String acct_id) {
		this.acct_id = acct_id;
	}

	public String getOrder_id() {
		return order_id;
	}

	public void setOrder_id(String order_id) {
		this.order_id = order_id;
	}

	public String getOrder_date() {
		return order_date;
	}

	public void setOrder_date(String order_date) {
		this.order_date = order_date;
	}

	public String getBusi_type() {
		return busi_type;
	}

	public void setBusi_type(String busi_type) {
		this.busi_type = busi_type;
	}

	public String getStart_date() {
		return start_date;
	}

	public void setStart_date(String start_date) {
		this.start_date = start_date;
	}

	public String getEnd_date() {
		return end_date;
	}

	public void setEnd_date(String end_date) {
		this.end_date = end_date;
	}

	public String getCursor() {
		return cursor;
	}

	public void setCursor(String cursor) {
		this.cursor = cursor;
	}

	public String getSize() {
		return size;
	}

	public void setSize(String size) {
		this.size = size;
	}

	@Override
	public String toString() {
		return "TradingQuery{" +
				"acct_id='" + acct_id + '\'' +
				", order_id='" + order_id + '\'' +
				", order_date='" + order_date + '\'' +
				", busi_type='" + busi_type + '\'' +
				", start_date='" + start_date + '\'' +
				", end_date='" + end_date + '\'' +
				", cursor='" + cursor + '\'' +
				", size='" + size + '\'' +
				", version='" + version + '\'' +
				", mer_id='" + mer_id + '\'' +
				", ret_code='" + ret_code + '\'' +
				", ret_msg='" + ret_msg + '\'' +
				", links=" + links +
				'}';
	}
}
