package com.fshows.umpay.bankchannel.model.account;

import com.fshows.umpay.sdk.request.MerchantBaseRequest;
import com.umpay.dto.UMFResponse;
import com.umpay.util.UMFUtil;
import lombok.Data;
import lombok.ToString;

/**
 * @author HEYUNHANG
 * @date 2023/3/28 15:19
 */
@ToString(callSuper = true)
@Data
public class AccountQuery extends MerchantBaseRequest {
    //请求参数
    private String mer_cust_id;

    private String acct_id;


    //响应参数
    /**
     * 电子账簿ID
     */
//    private String acct_id;

    /**
     * 电子账簿号
     */
    private String acct_no;

    /**
     * 单位分，可用余额
     */
    private String avl_bal;

    /**
     * 电子账簿是否被冻结
     * 1: 已冻结
     * 0: 未冻结
     */
    private String is_frozen;

    /**
     * 备注信息
     */
    private String remark;

    private String url = "/wxh/account/accountQuery";


    @Override
    public String getRequestUrl() {
        return baseUrl + url;
    }

    @Override
    public AccountQuery doRequest() throws Exception {
        UMFResponse.Message<AccountQuery> response = UMFUtil.post(createAPIContext(), this, AccountQuery.class);
        MerchantBaseRequest baseResult = convertResult(response, AccountQuery.class);
        if (baseResult == null)
            return null;
        return (AccountQuery) baseResult;
    }
}
