/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.bankchannel.client;

import com.fshows.umpay.bankchannel.request.UmBankBizRequest;
import com.fshows.umpay.bankchannel.response.UmBankBaseResponse;
import com.fshows.umpay.sdk.client.impl.UmpayApiDefinition;
import com.fshows.umpay.sdk.exception.UmPayException;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

/**
 * @author youmingming
 * @version UmBaseClient.java, v 0.1 2022-02-09 下午10:35 youmingming
 */
public interface UmBankClient {
    /**
     * 请求联动接口
     *
     * @param request            请求参数
     * @param umpayApiDefinition 方法枚举
     * @param <R>                返参
     * @return UmBaseResponse
     * <p>
     * UmpayApiDefinition api方法请参考下列API枚举
     * @see com.fshows.umpay.bankchannel.enums.UmBankChannelApiEnum
     */
    <R> UmBankBaseResponse<R> excute(UmBankBizRequest<R> request, UmpayApiDefinition umpayApiDefinition, String url) throws UmPayException;

    /**
     * 请求联动接口
     *
     * @param request            请求参数
     * @param umpayApiDefinition 方法枚举
     * @param postUrl            请求地址
     * @param <R>                返参
     * @return UmBaseResponse
     */
    <R> UmBankBaseResponse<R> excute(UmBankBizRequest<R> request, UmpayApiDefinition umpayApiDefinition, String postUrl, String subAppId) throws UmPayException;

    /**
     * 文件上传
     *
     * @param request            请求参数
     * @param umpayApiDefinition 方法枚举
     * @param postUrl            请求地址
     * @param <R>                返参
     * @return UmBaseResponse
     */
    <R> UmBankBaseResponse<R> uploadFile(UmBankBizRequest<R> request, UmpayApiDefinition umpayApiDefinition, File file, String postUrl, String subAppId) throws UmPayException;


    /**
     * 下载文件
     *
     * @param request            请求
     * @param umpayApiDefinition umpay api定义
     * @param getUrl             获取url
     * @return {@link UmBankBaseResponse }<{@link R }>
     * @author 范璟琛
     */
    <R> InputStream downloadFile(UmBankBizRequest<R> request, UmpayApiDefinition umpayApiDefinition, String getUrl) throws UmPayException;
}
