/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.trade.order;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 退款响应
 *
 * @author
 * @version UmpayRefundQueryResponse.java, v 0.1 2022-03-16 14:23:42
 */
@Data
public class UmpayRefundQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555667667905L;


    /**
     * 服务商外部退款号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outRefundNo长度不能超过32")
    private String outRefundNo;

    /**
     * 聚合收单平台退款号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "refundNo长度不能超过32")
    private String refundNo;

    /**
     * 服务商的交易订单号,可包含字母、数字、下划线;需保证在接入的服务商系统中唯一
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 退款订单的状态REFUND_SUCCESS 退款成功REFUND_PROCESSING退款中REFUND_FAILER退款失败
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "refundStatus长度不能超过30")
    private String refundStatus;

    /**
     * 聚合收单平台交易订单号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    /**
     * 微信侧退款订单号
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "plateRefundNo长度不能超过32")
    private String plateRefundNo;

    /**
     * 退款金额，单位为元
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal totalFee;

    /**
     * 实退金额，单位为元
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal netReceiptAmount;

    /**
     * 聚合收单平台手续费率
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal payPlatformRate;

    /**
     * 聚合收单平台手续费（单位元）
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal payPlatformFee;

    /**
     * 服务商费率接入的服务商设置的分佣费率
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal liquidatorCommissionRate;

    /**
     * 服务商手续费接入的服务商交易获得的返佣金额
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal liquidatorCommissionFee;

    /**
     * 补贴金额，单位元补贴金会原路退回至补贴金账户
     * <p>
     * (必填)
     */
    @NotNull
    private BigDecimal subsidyFee;

    /**
     * 剩余可退金额：元
     */
    private BigDecimal overAmount;

    /**
     * 优惠退款金额：元
     */
    private BigDecimal couponRefundFee;

    /**
     * 退款优惠信息
     */
    private String refundDetail;

    /**
     * 退款完成时间，格式为yyyy-MM-dd HH:mm:ss
     */
    private String refundTime;

    /**
     * 退款原因
     */
    @Length(max = 256, message = "refundReason长度不能超过256")
    private String refundReason;

    /**
     * 数币营销补贴金额
     */
    private BigDecimal ecnyAmount;
}