/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.terminal;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * POS终端绑定/解绑
 *
 * @author
 * @version UmpayTerminalBindOrUnbindResponse.java, v 0.1 2022-03-16 16:24:20
 */
@Data
public class UmpayTerminalBindOrUnbindResponse implements Serializable {

    private static final long serialVersionUID = -2213838555497301499L;


    /**
     * 子商户号，当一个商户存在多个子商户号时必填；
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "subMchId长度不能超过32")
    private String subMchId;

    /**
     * 支付平台：1-支付宝；2-微信；8-银行卡刷卡；
     *
     * (选填)
     */
    @Length(max = 1, message = "payPlatformType长度不能超过1")
    private String payPlatformType;

    /**
     * 设备类型取值范围：取值 取值说明02 传统POS03 mPOS04 智能POS08 手机POS10 条码支付受理终端11 辅助终端
     *
     * (选填)
     */
    @Length(max = 2, message = "terminalType长度不能超过2")
    private String terminalType;

    /**
     * 终端设备号；
     *
     * (选填)
     */
    @Length(max = 8, message = "terminalId长度不能超过8")
    private String terminalId;

    /**
     * 受理终端布放地址的纬度如服务商未上送纬度，则由业务系统根据装机地址生成经纬度信息
     *
     * (选填)
     */
    @Length(max = 32, message = "terminalGpsLat长度不能超过32")
    private String terminalGpsLat;

    /**
     * 受理终端布放地址的经度如服务商未上送经度，则由业务系统根据装机地址生成经纬度信息
     *
     * (选填)
     */
    @Length(max = 32, message = "terminalGpsLong长度不能超过32")
    private String terminalGpsLong;

}