/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.trade.order;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.trade.order.UmpayFeeSubsidyUploadResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 手续费补贴金上传
 *
 * @author
 * @version UmpayFeeSubsidyUploadRequest.java, v 0.1 2022-03-16 16:20:42
 */
@Data
public class UmpayFeeSubsidyUploadRequest extends UmBizRequest<UmpayFeeSubsidyUploadResponse> {

    private static final long serialVersionUID = -2213838555760310407L;


    /**
     * 聚合收单平台为商户分配的唯一&nbsp;ID,商户入驻后由平台返回；store_id和merchant_id二选一必填；
     *
     * (特殊必填)
     */
    @Length(max = 20, message = "storeId长度不能超过20")
    private String storeId;

    /**
     * 服务商的商户编号,由服务商自己定义,该商户编号必须在系统中唯一；store_id和merchant_id二选一必填；
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "merchantId长度不能超过32")
    private String merchantId;

    /**
     * 服务商订单号，out_trade_no和trade_no不能同时为空；trade_no和out_trade_no如果同时存在优先取trade_no
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "outTradeNo长度不能超过64")
    private String outTradeNo;

    /**
     * 聚合收单平台的订单号,在平台中唯一，out_trade_no和trade_no不能同时为空；trade_no和out_trade_no如果同时存在优先取trade_no
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "tradeNo长度不能超过64")
    private String tradeNo;

    /**
     * 上传类型：1-上传手续费&amp;补贴金；2-上传补贴金
     *
     * (必填)
     */
    @NotNull
    private Integer sendType;

    /**
     * 手续费，单位：元，保留两位小数当send_type=1时，必传
     *
     * (特殊必填)
     */
    private BigDecimal merchantFee;

    /**
     * 补贴金，单位：元，保留两位小数，可为0；
     *
     * (必填)
     */
    @NotNull
    private BigDecimal subsidyFee;

    @Override
    public Class<UmpayFeeSubsidyUploadResponse> getResponseClass() {
        return UmpayFeeSubsidyUploadResponse.class;
    }
}