/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.request.machine;

import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.machine.UmpayMachineQueryListResponse;
import lombok.Data;

/**
 * @author
 * @version UmpayOrderQueryRequest.java, v 0.1 2022-03-16 14:09:59
 */
@Data
public class UmpayMachineQueryRequest extends UmBizRequest<UmpayMachineQueryListResponse> {

    private static final long serialVersionUID = -2213838555707910492L;

    /**
     * 商户ID
     */
    private String storeId;

    /**
     *终端厂商编号，联系聚合平台运营人员；
     * 若terminal_type<>11-辅助终端，则prov_id必填；
     */
    private String provId;

    /**
     *终端型号，联系聚合平台运营人员；
     * 若terminal_type<>11-辅助终端，则model_id必填；
     */
    private String modelId;

    /**
     *终端SN号；可以为TUSN，
     * 若terminal_type<>11-辅助终端，则sn_number必填；
     */
    private String snNumber;

    /**
     *终端设备号；
     * 当bind_type=1-pos终端解绑时，
     * terminal_id和（prov_id、model_id、sn_number）二选一必填；
     */
    private String terminalId;

    /**
     *子商户号，当一个商户存在多个子商户号时必填；
     */
    private String subMchId;

    @Override
    public Class<UmpayMachineQueryListResponse> getResponseClass() {
        return UmpayMachineQueryListResponse.class;
    }
}