/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.merchant.item;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author youmingming
 * @version MerchantRateResponse.java, v 0.1 2022-02-09 下午5:32 youmingming
 */
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@Data
public class MerchantRateItemResponse implements Serializable {

    private static final long serialVersionUID = 6321770706526271708L;

    /**
     * 平台类型：1-支付宝线下；3-微信线下；20-银联云闪付；
     * 300-支付宝0费率；301-支付宝0.1%费率；232-微信0费率；233-微信0.1%费率；234-微信0.3%费率；235-微信0.38%费率；236-微信0.6%费率；
     */
    private String payType;

    /**
     * 商户终端费率
     */
    private BigDecimal merchantRate;
}