/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version UmMerchantApiEnum.java, v 0.1 2022-02-09 下午10:41 youmingming
 */
public enum UmMerchantApiEnum {
    AGGREGATION_MERCHANT_ENTER("商户入驻", "aggregation.merchant.enter"),
    AGGREGATION_MERCHANT_MODIFY("商户信息修改", "aggregation.merchant.modify");

    private String name;
    private String value;

    UmMerchantApiEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static UmMerchantApiEnum getByValue(String value) {
        UmMerchantApiEnum[] valueList = UmMerchantApiEnum.values();
        for (UmMerchantApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}