/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.swift.client.impl.http;

import cn.hutool.core.collection.CollectionUtil;
import com.fshows.swift.client.base.ApiClientConfig;
import com.fshows.swift.client.base.SwiftHttpResult;
import com.fshows.swift.client.base.IHttpRequest;
import com.fshows.swift.util.FsHttpUtil;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * http请求实现类
 *
 * @author liluqing
 * @version DefaultHttpRequest.java, v 0.1 2022-03-02 18:19
 */
public class DefaultHttpRequestImpl implements IHttpRequest {

    @Override
    public SwiftHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws Exception {
        Map<String, String> headers = new HashMap<>();

        String fsHttpResult = FsHttpUtil.postString(
                url,
                requestBody,
                apiClientConfig.getCharset(),
                "application/xml;charset=UTF-8",
                apiClientConfig.getConnectionTimeout(),
                apiClientConfig.getReadTimeout(),
                headers);
        if (fsHttpResult != null) {
            return convertHttpResult(fsHttpResult, apiClientConfig);
        }
        return null;
    }


    /**
     * fsHttpResult 转>> SwiftHttpResult
     *
     * @param response        响应
     * @param apiClientConfig API客户端配置
     * @return {@link SwiftHttpResult}
     * @throws ParserConfigurationException 解析器配置异常
     * @throws IOException                  ioexception
     * @throws SAXException                 saxexception
     */
    private SwiftHttpResult convertHttpResult(String response, ApiClientConfig apiClientConfig) throws ParserConfigurationException, IOException, SAXException {
        SwiftHttpResult swiftHttpResult = new SwiftHttpResult();
        swiftHttpResult.setBody(URLDecoder.decode(response, apiClientConfig.getCharset()));
        return swiftHttpResult;
    }

    /**
     * 从headList中获取具体某个key值
     *
     * @param key
     * @param headList
     * @return
     */
    private String getHeadFeild(String key, Map<String, List<String>> headList) {
        if (headList == null) {
            return null;
        }
        List<String> valueList = headList.get(key);
        if (CollectionUtil.isEmpty(valueList)) {
            return null;
        }
        return valueList.get(0);
    }
}