/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.swift.response.base;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 响应业务参数基类
 *
 * @author liluqing
 * @version SwiftBizResponse.java, v 0.1 2022-03-02 11:26
 */
@Data
public class SwiftBizResponse implements Serializable {

    private static final long serialVersionUID = 2060832299651356241L;

    /**
     * 服务商公众号APPID
     * (选填)
     */
    private String appid;

    /**
     * 可选值 UTF-8 ，默认为 UTF-8。
     * (必填)
     */
    private String charset;

    /**
     * 签名类型，取值：MD5、RSA_1_256、RSA_1_1，默认：MD5
     * (必填)
     */
    private String signType;

    /**
     * 0表示成功，非0表示失败此字段是通信标识，非交易标识，交易是否成功需要查看 result_code 来判断
     * (必填)
     */
    private String status;

    /**
     * 0表示成功，非0表示失败
     * (必填)
     */
    private String resultCode;

    /**
     * 返回信息，如非空，为错误原因签名失败参数格式校验错误
     * (选填)
     */
    private String message;

    /**
     * 网关返回码
     * (选填)
     */
    private String code;

    /**
     * 随机字符串，不长于 32 位
     * (必填)
     */
    private String nonceStr;

    /**
     * 参考错误码
     * (选填)
     */
    private String errCode;

    /**
     * 结果信息描述
     * (选填)
     */
    private String errMsg;

    /**
     * 原始响应数据
     */
    private Map<String, String> resMap;
}