/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.swift.client.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import com.fshows.swift.client.base.ApiClientConfig;
import com.fshows.swift.client.base.IHttpRequest;
import com.fshows.swift.client.base.ISwiftApiDefinition;
import com.fshows.swift.client.base.ISigner;
import com.fshows.swift.client.base.SignParam;
import com.fshows.swift.exception.SwiftApiException;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.base.SwiftBizResponse;
import com.fshows.swift.util.RequestParamUtils;
import com.fshows.swift.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * 威富通交易接口客户端
 *
 * @author liluqing
 * @version TradeSwiftApiClientImpl.java, v 0.1 2022-03-04 15:02
 */
@Slf4j
public class TradeSwiftApiClientImpl extends AbstractSwiftApiClientImpl {

    public TradeSwiftApiClientImpl(ApiClientConfig apiClientConfig) throws SwiftApiException {
        super(apiClientConfig);
    }

    public TradeSwiftApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws SwiftApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends SwiftBizResponse, R extends ISwiftApiDefinition> T execute(SwiftBizRequest<T, R> request, R tradeApiDefinitionEnum) throws SwiftApiException {
        return (T) super.doExecute(request, tradeApiDefinitionEnum);
    }

    /**
     * 添加公共参数构建完整的请求
     *
     * @param bizRequest 业务请求参数
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected SwiftBizRequest buildSwiftBizRequest(SwiftBizRequest bizRequest, ISwiftApiDefinition tradeApiDefinitionEnum) {
        // 补充参数
//        bizRequest.setInsCd(apiClientConfig.getAppId());
//        bizRequest.setVersion(tradeApiDefinitionEnum.getVersion());
//        bizRequest.setRandomStr(IdUtil.simpleUUID());
        return bizRequest;
    }

    @Override
    protected SignParam buildSignParam(SwiftBizRequest baseRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(apiClientConfig.getAppId());
        signParam.setNonceStr(RandomUtil.randomString(12));
        signParam.setRequest(baseRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(SwiftBizRequest baseRequest, String sign, ISwiftApiDefinition tradeApiDefinitionEnum) {
        Map<String, String> requstMap = RequestParamUtils.toMap(baseRequest);
        return RequestParamUtils.generateXml(requstMap);
    }

    @Override
    protected SwiftBizResponse parseResponse(String resBody, ISwiftApiDefinition tradeApiDefinitionEnum) throws SwiftApiException {
        try {
            Map<String, String> resMap = RequestParamUtils.getMapFromXML(resBody);
            SwiftBizResponse swiftBizResponse = RequestParamUtils.getObjectFromMap(resMap, tradeApiDefinitionEnum.getResponseClass());
            swiftBizResponse.setResMap(resMap);
            return swiftBizResponse;
        } catch (Exception e) {
            LogUtil.error(log, "【swiftpass-sdk】响应结果反序列化异常 >> resBody={}", e, resBody);
            throw new SwiftApiException("[swiftpass-sdk]响应结果反序列化异常");
        }
    }
}