/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.shande.openapi.sdk.util;

public class SnowflakeIdWorkerUtils {
    private static final long twepoch = 1514736000000L;
    private static final long workerIdBits = 5L;
    private static final long datacenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static final long maxDataCenterId = 31L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long dataCenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private static long workerId;
    private static long dataCenterId;
    private static long sequence;
    private static long lastTimestamp;

    public SnowflakeIdWorkerUtils(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        SnowflakeIdWorkerUtils.workerId = workerId;
        SnowflakeIdWorkerUtils.dataCenterId = dataCenterId;
    }

    static synchronized String nextId() {
        long timestamp = SnowflakeIdWorkerUtils.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = SnowflakeIdWorkerUtils.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return String.valueOf(timestamp - 1514736000000L << 22 | dataCenterId << 17 | workerId << 12 | sequence);
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = SnowflakeIdWorkerUtils.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = SnowflakeIdWorkerUtils.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    static {
        sequence = 0L;
        lastTimestamp = -1L;
    }
}

