/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.shande.openapi.sdk.util;

import com.fshows.com.shande.openapi.sdk.crypto.AESWithCBCStrategy;
import com.fshows.com.shande.openapi.sdk.crypto.AESWithECBStrategy;
import com.fshows.com.shande.openapi.sdk.crypto.CryptoEncryptionService;
import com.fshows.com.shande.openapi.sdk.crypto.CryptoSignatureService;
import com.fshows.com.shande.openapi.sdk.crypto.RSACryptoWithHardwareStrategy;
import com.fshows.com.shande.openapi.sdk.crypto.RSACryptoWithSoftwareStrategy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class CryptoServiceUtils {
    private static volatile Map<String, CryptoEncryptionService> cryptoAESEncryptionServiceMap = new HashMap<String, CryptoEncryptionService>();
    private static volatile Map<String, CryptoEncryptionService> cryptoRSAEncryptionServiceMap = new HashMap<String, CryptoEncryptionService>();
    private static volatile Map<String, CryptoSignatureService> cryptoSignatureServiceMap = new HashMap<String, CryptoSignatureService>();

    private static void initialCryptoService() throws Exception {
        HashSet<CryptoEncryptionService> cryptoAESEncryptionServiceSet = new HashSet<CryptoEncryptionService>();
        cryptoAESEncryptionServiceSet.add(new AESWithCBCStrategy());
        cryptoAESEncryptionServiceSet.add(new AESWithECBStrategy());
        CryptoServiceUtils.initialCryptoAESEncryptionService(cryptoAESEncryptionServiceSet);
        HashSet<CryptoEncryptionService> cryptoRSAEncryptionServiceSet = new HashSet<CryptoEncryptionService>();
        cryptoRSAEncryptionServiceSet.add(new RSACryptoWithHardwareStrategy());
        cryptoRSAEncryptionServiceSet.add(new RSACryptoWithSoftwareStrategy());
        CryptoServiceUtils.initialCryptoRSAEncryptionService(cryptoRSAEncryptionServiceSet);
        HashSet<CryptoSignatureService> CryptoSignatureServiceSet = new HashSet<CryptoSignatureService>();
        CryptoSignatureServiceSet.add(new RSACryptoWithHardwareStrategy());
        CryptoSignatureServiceSet.add(new RSACryptoWithSoftwareStrategy());
        CryptoServiceUtils.initialCryptoSignatureService(CryptoSignatureServiceSet);
    }

    private static void initialCryptoAESEncryptionService(HashSet<CryptoEncryptionService> cryptoEncryptionServiceClassSet) throws Exception {
        for (CryptoEncryptionService cryptoEncryptionService : cryptoEncryptionServiceClassSet) {
            cryptoAESEncryptionServiceMap.put(cryptoEncryptionService.getAlgorithmType(), cryptoEncryptionService);
        }
    }

    private static void initialCryptoRSAEncryptionService(HashSet<CryptoEncryptionService> cryptoEncryptionServiceClassSet) throws Exception {
        for (CryptoEncryptionService cryptoEncryptionService : cryptoEncryptionServiceClassSet) {
            cryptoRSAEncryptionServiceMap.put(cryptoEncryptionService.getAlgorithmType(), cryptoEncryptionService);
        }
    }

    private static void initialCryptoSignatureService(HashSet<CryptoSignatureService> cryptoSignatureServiceSet) throws Exception {
        for (CryptoSignatureService cryptoSignatureService : cryptoSignatureServiceSet) {
            cryptoSignatureServiceMap.put(cryptoSignatureService.getAlgorithmType(), cryptoSignatureService);
        }
    }

    public static CryptoEncryptionService getCryptoAESEncryptionService(String encryptType) throws Exception {
        String typeUpperCase = encryptType.toUpperCase(Locale.getDefault());
        return cryptoAESEncryptionServiceMap.get(typeUpperCase);
    }

    public static void putCryptoAESEncryptionService(CryptoEncryptionService cryptoEncryptionService) {
        if (cryptoEncryptionService != null) {
            cryptoAESEncryptionServiceMap.put(cryptoEncryptionService.getAlgorithmType(), cryptoEncryptionService);
        }
    }

    public static CryptoEncryptionService getCryptoRSAEncryptionService(String encryptType) throws Exception {
        String typeUpperCase = encryptType.toUpperCase(Locale.getDefault());
        return cryptoRSAEncryptionServiceMap.get(typeUpperCase);
    }

    public static void putCryptoRSAEncryptionService(CryptoEncryptionService cryptoEncryptionService) {
        if (cryptoEncryptionService != null) {
            cryptoRSAEncryptionServiceMap.put(cryptoEncryptionService.getAlgorithmType(), cryptoEncryptionService);
        }
    }

    public static CryptoSignatureService getCryptoSignatureService(String signType) throws Exception {
        String typeUpperCase = signType.toUpperCase(Locale.getDefault());
        return cryptoSignatureServiceMap.get(typeUpperCase);
    }

    public static void putCryptoSignatureService(CryptoSignatureService cryptoSignatureService) {
        if (cryptoSignatureService != null) {
            cryptoSignatureServiceMap.put(cryptoSignatureService.getAlgorithmType(), cryptoSignatureService);
        }
    }

    static {
        try {
            CryptoServiceUtils.initialCryptoService();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

