/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.shande.openapi.sdk.service;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fshows.com.shande.openapi.sdk.client.OpenParameters;
import com.fshows.com.shande.openapi.sdk.client.ShandeOpenApiClient;
import com.fshows.com.shande.openapi.sdk.config.Configuration;
import com.fshows.com.shande.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fshows.com.shande.openapi.sdk.constant.RequestVerifyTypeEnum;
import com.fshows.com.shande.openapi.sdk.crypto.CryptoEncryptionService;
import com.fshows.com.shande.openapi.sdk.crypto.CryptoSignatureService;
import com.fshows.com.shande.openapi.sdk.service.OpenApiService;
import com.fshows.com.shande.openapi.sdk.util.AESUtils;
import com.fshows.com.shande.openapi.sdk.util.CryptoServiceUtils;
import com.fshows.com.shande.openapi.sdk.util.SerialNoUtils;
import com.fshows.shande.sdk.common.ReqIdUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenApiService
implements OpenApiService {
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(ShandeOpenApiClient client, OpenParameters context) throws Exception {
        HttpURLConnection connection = null;
        try {
            Configuration configuration = client.getConfiguration();
            String body = this.buildBody(configuration, context);
            connection = this.getHttpURLConnection(configuration, context);
            byte[] response = this.getResponse(connection, body, configuration.charset());
            String result = this.verifyAndDecrypt(connection, configuration, context, response);
            this.logger.debug("request >> \u886b\u5fb7\u8bf7\u6c42\u7ed3\u675f >> url={}, request={}, result = {}", new Object[]{connection.getURL(), body, result});
            String string = result;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private String buildBody(Configuration configuration, OpenParameters context) throws Exception {
        String randomKey = AESUtils.randomKey();
        String encryptType = configuration.encryptType();
        String signType = configuration.signType();
        CryptoEncryptionService rsaEncryptionService = CryptoServiceUtils.getCryptoRSAEncryptionService(signType);
        String shandeEncPubKey = this.matchesShandeEncPubKey(context.getVerifyTypeEnum(), configuration);
        String randomKeyEncrypt = rsaEncryptionService.encrypt(randomKey, shandeEncPubKey);
        this.logger.debug("signType is {}, randomKeyEncrypt is {}", (Object)signType, (Object)randomKeyEncrypt);
        CryptoEncryptionService aesEncryptionService = CryptoServiceUtils.getCryptoAESEncryptionService(encryptType);
        String data = aesEncryptionService.encrypt(context.getParams(), randomKey);
        this.logger.debug("randomKey is {}, encryptType is {}, encrypt result is {}", new Object[]{randomKey, encryptType, data});
        TreeMap<String, String> requestMap = new TreeMap<String, String>();
        requestMap.put("mid", configuration.mid());
        requestMap.put("timestamp", DateUtil.now());
        requestMap.put("version", "1.0.0");
        requestMap.put("customerOrderNo", ReqIdUtil.getId());
        requestMap.put("signType", "SHA1WithRSA");
        requestMap.put("encryptType", "AES");
        requestMap.put("encryptKey", randomKeyEncrypt);
        requestMap.put("data", data);
        JSONObject orderRequestMap = AESUtils.getAloneKeys(new JSONObject(requestMap));
        String preSignData = AESUtils.getPreSignData(orderRequestMap);
        CryptoSignatureService cryptoSignatureService = CryptoServiceUtils.getCryptoSignatureService(signType);
        String fubeiSignPrivateKey = this.matchesFubeiSignPrivateKey(context.getVerifyTypeEnum(), configuration);
        String signData = cryptoSignatureService.signature(preSignData, fubeiSignPrivateKey);
        this.logger.debug("signature result is {}", (Object)signData);
        orderRequestMap.put("sign", (Object)signData);
        this.logger.debug("request >> \u886b\u5fb7\u8bf7\u6c42\u5f00\u59cb >> orderRequestMap = {}", (Object)orderRequestMap);
        return orderRequestMap.toJSONString();
    }

    public String matchesShandeEncPubKey(RequestVerifyTypeEnum verifyTypeEnum, Configuration configuration) {
        String shandeEncPubKey = null;
        if (RequestVerifyTypeEnum.ACCOUNT_OPENING.equals((Object)verifyTypeEnum)) {
            shandeEncPubKey = configuration.shandeAccountOpeningEncPubKey();
        } else if (RequestVerifyTypeEnum.OUT_FUND.equals((Object)verifyTypeEnum)) {
            shandeEncPubKey = configuration.shandeOutFundEncPubKey();
        } else if (RequestVerifyTypeEnum.IN_FUND.equals((Object)verifyTypeEnum)) {
            // empty if block
        }
        return shandeEncPubKey;
    }

    public String matchesFubeiSignPrivateKey(RequestVerifyTypeEnum verifyTypeEnum, Configuration configuration) {
        String fubeiSignPrivateKey = null;
        if (RequestVerifyTypeEnum.ACCOUNT_OPENING.equals((Object)verifyTypeEnum)) {
            fubeiSignPrivateKey = configuration.fubeiAccountOpeningSignPrivateKey();
        } else if (RequestVerifyTypeEnum.OUT_FUND.equals((Object)verifyTypeEnum)) {
            fubeiSignPrivateKey = configuration.fubeiOutFundSignPrivateKey();
        } else if (RequestVerifyTypeEnum.IN_FUND.equals((Object)verifyTypeEnum)) {
            // empty if block
        }
        return fubeiSignPrivateKey;
    }

    private HttpURLConnection getHttpURLConnection(Configuration configuration, OpenParameters context) throws IOException {
        URL url = new URL(this.pseudoModuleCode(context, this.getRemoteAddress(configuration)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setHttpHeaders(configuration, context, connection);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestMethod(this.getHttpMethod());
        connection.setConnectTimeout(configuration.connectionTimeout());
        connection.setReadTimeout(configuration.readTimeout());
        return connection;
    }

    protected String getRemoteAddress(Configuration configuration) {
        return configuration.remoteAddress();
    }

    private String pseudoModuleCode(OpenParameters context, String address) {
        address = address + context.getApiName();
        return address;
    }

    private void setHttpHeaders(Configuration configuration, OpenParameters context, HttpURLConnection connection) {
        connection.setRequestProperty("api_name", context.getApiName());
        this.setAlgorithm(configuration, connection);
        String clientSerialNo = SerialNoUtils.calculateSerialNo(context.getParams());
        connection.setRequestProperty("client_serial_no", clientSerialNo);
        connection.setRequestProperty("Content-Type", "application/json");
    }

    protected void setAlgorithm(Configuration configuration, HttpURLConnection connection) {
        if (AlgorithmTypeEnum.RSA_HARDWARE.getAlgorithmType().equals(configuration.signType())) {
            connection.setRequestProperty("algorithm", "rsaDetached");
        }
    }

    protected String getHttpMethod() {
        return "POST";
    }

    private byte[] getResponse(HttpURLConnection connection, String encryptedBody, Charset charset) throws IOException {
        try (OutputStream outputStream = connection.getOutputStream();){
            if (null != encryptedBody) {
                outputStream.write(encryptedBody.getBytes(charset));
                outputStream.flush();
            }
        }
        var5_5 = null;
        try (InputStream in = connection.getInputStream();){
            byte[] byArray = this.read(in);
            return byArray;
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    private byte[] read(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int num;
            int defaultBufferSize = 8192;
            byte[] buffer = new byte[8192];
            this.logger.debug("read data begin");
            while ((num = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, num);
            }
            byte[] readResult = outputStream.toByteArray();
            this.logger.debug("read data end");
            byte[] byArray = readResult;
            return byArray;
        }
    }

    public String verifyAndDecrypt(HttpURLConnection connection, Configuration configuration, OpenParameters context, byte[] response) throws Exception {
        String responseStr = null;
        try {
            responseStr = new String(response, configuration.charset());
            String shandeEncPubKey = this.matchesShandeEncPubKey(context.getVerifyTypeEnum(), configuration);
            JSONObject json = this.verifySignature(configuration, responseStr, shandeEncPubKey);
            String dataResult = this.decryptResult(configuration, context, json);
            json.put("data", (Object)dataResult);
            return json.toString();
        }
        catch (Exception e) {
            this.logger.error("request >> \u886b\u5fb7\u8bf7\u6c42\u7ed3\u675f >> \u8bf7\u6c42\u6749\u5fb7\u9a8c\u7b7e\u5931\u8d25 >> url={}, request = {}, response={}", new Object[]{this.pseudoModuleCode(context, this.getRemoteAddress(configuration)), context.getParams(), responseStr});
            throw e;
        }
    }

    private JSONObject verifySignature(Configuration configuration, String encryptedResult, String publicKey) throws Exception {
        String preSignData;
        Map encryptedResultMap = (Map)JSONObject.parseObject((String)encryptedResult, (TypeReference)new TypeReference<TreeMap<String, Object>>(){}, (Feature[])new Feature[0]);
        Object signData = encryptedResultMap.remove("sign");
        JSONObject encryptedResultJson = new JSONObject(encryptedResultMap);
        CryptoSignatureService cryptoService = CryptoServiceUtils.getCryptoSignatureService(configuration.signType());
        boolean verifyResult = cryptoService.verifySignature(preSignData = AESUtils.getPreSignData(encryptedResultJson), signData.toString(), publicKey);
        if (!verifyResult) {
            this.logger.error("The result signature verify failed, encryptedResult is : {} ", (Object)encryptedResult);
            throw new IllegalArgumentException("Verify signature failed.");
        }
        return encryptedResultJson;
    }

    public String decryptResult(Configuration configuration, OpenParameters context, JSONObject json) throws Exception {
        String encryptedRandomKey = json.getString("encryptKey");
        CryptoEncryptionService rsaCryptoEncryptionService = CryptoServiceUtils.getCryptoRSAEncryptionService(configuration.signType());
        String fubeiSignPrivateKey = this.matchesFubeiSignPrivateKey(context.getVerifyTypeEnum(), configuration);
        String randomKey = rsaCryptoEncryptionService.decrypt(encryptedRandomKey, fubeiSignPrivateKey);
        CryptoEncryptionService aesCryptoEncryptionService = CryptoServiceUtils.getCryptoAESEncryptionService(configuration.encryptType());
        return aesCryptoEncryptionService.decrypt(json.getString("data"), randomKey);
    }
}

