/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.merchant;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 二级商户（企业用户）进件响应结果
 *
 * @author
 * @version ShandeApplicationsSubmchAddResponse.java, v 0.1 2022-12-06 15:02:36
 */
@Data
public class ShandeApplicationsSubmchAddResponse implements Serializable {

    private static final long serialVersionUID = -2213838555304961701L;


    /**
     * 系统订单号
     * 系统唯一的申请单号示例值： 6202122273880868927
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "mchApplicationId长度不能超过19")
    private String mchApplicationId;

    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、每个平台订单号对应一个系统订单 号，每个系统订单号创建成功后会生成一个二级商户 ID3、若申请单审核 “失败”，可填写相同的 “平台订单号”再次请求，覆盖原申请单信息4、要求 64 个字符内，只能是数字、大小写字母和_-
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

}