/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.merchant;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 查询用户或二级商户是否进件响应结果
 *
 * @author
 * @version ShandeApplicationsQueryResponse.java, v 0.1 2022-12-06 11:47:41
 */
@Data
public class ShandeApplicationsQueryResponse implements Serializable {

    private static final long serialVersionUID = -2213838555780648059L;


    /**
     * 进件状态
     * checking：资料校验中account_need_veri fy：待账户验证auditing：审核中processing：处理中signing：电子签约中succeeded：已通过failed：被驳回frozen：已冻结
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "applicationStatus长度不能超过20")
    private String applicationStatus;

    /**
     * 二级商户ID
     * 当进件状态为succeeded 时返回
     *
     * (特殊必填)
     */
    private String mchId;

    /**
     * 用户ID
     * 当进件状态为succeeded 时返回
     *
     * (特殊必填)
     */
    private String cusId;

    /**
     * 电子账簿号
     * 当进件状态为succeeded 时返回
     *
     * (特殊必填)
     */
    private String relAcctNo;

    /**
     * 电子账簿ID
     * 当进件状态为succeeded 时返回
     *
     * (特殊必填)
     */
    private String accountId;

}