/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.fund;

import com.fshows.shande.sdk.response.fund.item.ShandeProductInfoItemResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * 消费（转账）订单查询响应结果
 *
 * @author
 * @version ShandeFundPaymentsQueryOutResponse.java, v 0.1 2022-12-06 09:21:23
 */
@Data
public class ShandeFundPaymentsQueryOutResponse implements Serializable {

    private static final long serialVersionUID = -2213838555992317158L;


    /**
     * 系统订单号
     * 由系统生成的唯一单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "paymentId长度不能超过19")
    private String paymentId;

    /**
     * 交易状态
     * succeeded: 成功processing: 处理中 failed: 失败
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "status长度不能超过10")
    private String status;

    /**
     * 失败原因
     * 失败时的具体错误原因描述
     *
     * (特殊必填)
     */
    @Length(max = 200, message = "reason长度不能超过200")
    private String reason;

    /**
     * 创建时间
     * 格式: RFC3339
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 25, message = "createdAt长度不能超过25")
    private String createdAt;

    /**
     * 完成时间
     * 格式: RFC3339
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 25, message = "finishedAt长度不能超过25")
    private String finishedAt;

    /**
     * 平台订单号
     * 平台的唯一请求单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

    /**
     * 交易金额
     * 单位为分，要求不能带小数点
     *
     * (必填)
     */
    @NotNull
    private Integer amount;

    /**
     * 已退款金额
     * 1、已退款金额，单位为分2、未退款时，该金额为 0
     *
     * (必填)
     */
    @NotNull
    private Integer refundedAmount;

    /**
     * 付款电子账簿 ID
     * 付款用户的电子账簿ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "payBalanceAcctId长度不能超过19")
    private String payBalanceAcctId;

    /**
     * 收款电子账簿 ID
     * 收款用户的电子账簿ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "recvBalanceAcctId长度不能超过19")
    private String recvBalanceAcctId;

    /**
     * 备注
     * 备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

    /**
     * 扩展字段
     * 预留扩展字段交易涉及的商品信息，根据必传要求上 送，参考示例
     * extra[product_infos] {@link ShandeProductInfoItemResponse}
     * extra[notify_url] 交易结果通知地址,用于接收异步通知地址的 URL
     * (特殊必填)
     */
    private Map<String,Object> extra;

    /**
     * 自定义参数
     * {"purpose":"123456"}
     *
     * (选填)
     */
    private Map<String,String> metadata;

}