/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 营业执照信息
 *
 * @author liluqing
 * @version ShandeBusinessLicenseRequest.java, v 0.1 2022-12-06 14:46
 */
@Data
public class ShandeBusinessLicenseRequest implements Serializable {

    private static final long serialVersionUID = -2213838555911708488L;

    /**
     * 营业执照扫描件
     * 可上传 1 张图片，请填写通过[图片上传接口预先上传图片生成好的 media_id图片要求：（1）请上传证件的彩色扫描件或彩色数码拍摄件。上传黑白复印件需加盖公章，且公章信息需完整不得添加与二级商户进件用途无关水印证件正面拍摄件的信息必须完整且清晰可见不符合上述要求以及二次剪裁、翻拍、PS证件照片的进件均不接受
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "copy长度不能超过255")
    private String copy;

    /**
     * 营业执照注册号
     * <p>
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 18, message = "number长度不能超过18")
    private String number;

    /**
     * 营业执照公司名称
     * 1、 请填写营业执照的商家名称，支持中文、字母、数字、括号、& 符号2、 个体工商户不能以“公司”结尾3、 个体工商户，若营业执照上商户名称为空或为 “无”，请填写“个体户+经营者姓名”，如“个体户张三”
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "companyName长度不能超过64")
    private String companyName;

    /**
     * 营业执照注册地址
     * 营业执照注册地址
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "companyAddress长度不能超过128")
    private String companyAddress;

    /**
     * 营业期限
     * 1、若证件有效期为长期，到期时间请填写：长期 2、到期时间需晚于成立时间3、营业执照有效期到期时间必须大于 60 天，即到期时间距当前时间需超过 60 天4、格式：1990-01-01，长期
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "validTime长度不能超过32")
    private String validTime;
}