/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.merchant;

import com.fshows.shande.sdk.request.ShandeRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeApplicationsSettleAcctRequest;
import com.fshows.shande.sdk.request.merchant.item.ShandeIdCardItemRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Map;

/**
 * 个人用户信息修改入参
 *
 * @author
 * @version ShandeCusApplicationsRenewRequest.java, v 0.1 2022-12-06 14:34:32
 */
@Data
public class ShandeCusApplicationsRenewRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555438526821L;


    /**
     * 个人用户 ID
     * 进件成功返回的个人用户用户 ID 示例值:11021612019362222 19
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "cusId长度不能超过19")
    private String cusId;

    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、每个平台订单号对应一个系统订单号，每个系统订单号创建成功后会生成一个个人用户 ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

    /**
     * 证件信息
     * 个人用户证件信息
     * {@link ShandeIdCardItemRequest}
     * (必填)
     */
    @NotNull
    private ShandeIdCardItemRequest idCard;

    /**
     * 手机号码
     * 1、仅支持 11 位数字手机号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 11, message = "mobileNumber长度不能超过11")
    private String mobileNumber;

    /**
     * 绑定账户信息
     * {@link com.fshows.shande.sdk.request.merchant.item.ShandeApplicationsSettleAcctRequest}
     * (必填)
     */
    @NotNull
    private ShandeApplicationsSettleAcctRequest settleAcct;

    /**
     * 短信验证码
     * 1、通过[个人手机号验证码]接口获取的短信验证码2、若未修改手机号码，可不传
     *
     * (必填)
     */
    @Length(max = 6, message = "smsCode长度不能超过6")
    private String smsCode;

    /**
     * 国籍
     * 枚举值：1：中国2：其它国家或地区
     *
     * (选填)
     */
    @Length(max = 3, message = "nationality长度不能超过3")
    private String nationality;

    /**
     * 性别
     * 枚举值:1：男2：女
     *
     * (选填)
     */
    @Length(max = 1, message = "gender长度不能超过1")
    private String gender;

    /**
     * 住所地或工作单位地址
     * 
     *
     * (选填)
     */
    @Length(max = 128, message = "workAddress长度不能超过128")
    private String workAddress;


    /**
     * 自定义参数
     * {"description":"123456"}
     *
     * (选填)
     */
    private Map<String,Object> metadata;

    /**
     * 额外信息
     * 按管理后台配置情况填写
     * extra[contractNo] 合同编号
     *
     * (选填)
     */
    private Map<String,String> extra;

}