/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.fund;

import com.fshows.shande.sdk.request.ShandeRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Map;

/**
 * 提现创建入参
 *
 * @author
 * @version ShandeFundWithdrawalsOutRequest.java, v 0.1 2022-12-06 09:06:57
 */
@Data
public class ShandeFundWithdrawalsOutRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555905779217L;


    /**
     * 平台订单号
     * 1、平台的唯一请求单号
     * 2、要求 64 个字符内，只能是数字、大小写字母和_-
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outOrderNo长度不能超过64")
    private String outOrderNo;

    /**
     * 发送时间
     * 格式: RFC3339
     * <p>
     * (选填)
     */
    @Length(max = 25, message = "sentAt长度不能超过25")
    private String sentAt;

    /**
     * 金额
     * 单位为分，要求不能带小数点
     * <p>
     * (必填)
     */
    @NotNull
    private Integer amount;

    /**
     * 平台手续费
     * 计入平台手续费功能账簿，不传为 0单位为分，要求不能带小数点
     * <p>
     * (选填)
     */
    private Integer serviceFee;

    /**
     * 电子账簿 ID
     * 申请提现用户的电子账簿编号
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 业务类型
     * 枚举值：1- 提现、2- 转账 默认值为 1
     * <p>
     * (选填)
     */
    @Length(max = 1, message = "businessType长度不能超过1")
    private String businessType;

    /**
     * 提现目标银行账号
     * <p>
     * <p>
     * (必填)
     */
    @NotBlank
    @Length(max = 34, message = "bankAcctNo长度不能超过34")
    private String bankAcctNo;

    /**
     * 目标银行账号类型
     * 提现至非绑定账户时必填枚举值：
     * 1- 对私银行卡
     * 2- 对公银行账户
     * <p>
     * (特殊必填)
     */
    @Length(max = 1, message = "bankAcctType长度不能超过1")
    private String bankAcctType;

    /**
     * 开户银行联行号
     * 提现至非绑定账户时必填
     * <p>
     * (特殊必填)
     */
    @Length(max = 12, message = "bankBranchCode长度不能超过12")
    private String bankBranchCode;

    /**
     * 开户银行编号
     * 1、提现至非绑定账户时必填2、详情参见：[银行编码表]
     * <p>
     * (特殊必填)
     */
    @Length(max = 12, message = "bankCode长度不能超过12")
    private String bankCode;

    /**
     * 开户名称
     * 1、提现至非绑定账户时必填
     * <p>
     * (特殊必填)
     */
    @Length(max = 32, message = "name长度不能超过32")
    private String name;

    /**
     * 银行附言
     * 提现用户填写的附言信息
     * <p>
     * (选填)
     */
    @Length(max = 30, message = "bankMemo长度不能超过30")
    private String bankMemo;

    /**
     * 手机号
     * <p>
     * <p>
     * (选填)
     */
    @Length(max = 11, message = "mobileNumber长度不能超过11")
    private String mobileNumber;

    /**
     * 备注
     * 备注信息
     * <p>
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

    /**
     * 扩展字段
     * 预留扩展字段
     * extra[notify_url] 交易结果通知地址，用于接收异步通知地址的URL
     * <p>
     * (选填)
     */
    private Map<String,Object> extra;
    /**
     * 自定义参数
     * {"purpose":"123456"}
     * <p>
     * (选填)
     */
    private Map<String, String> metadata;

}