/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.common;

import com.fshows.shande.sdk.request.ShandeRequest;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 上传图片入参
 *
 * @author
 * @version ShandeUploadImageRequest.java, v 0.1 2022-12-06 10:46:50
 */
@Data
public class ShandeUploadImageRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555285286012L;


    /**
     * 图片文件
     * 1、支持 JPG、BMP、PNG 格式；2、文件大小不能超过 5M；3、文件名称长度不能超过 255 4、base64编码
     *
     * (必填)
     */
    @NotNull
    private String file;

    /**
     * 文件名
     * 
     *
     * (必填)
     */
    @NotBlank
    private String filename;

}