/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.books;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 新增电子账簿入参
 *
 * @author
 * @version ShandeAccountBookAddRequest.java, v 0.1 2022-12-05 19:49:52
 */
@Data
public class ShandeAccountBookAddRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555754347934L;


    /**
     * 平台订单
     * 1、平台自定义的唯一编
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

    /**
     * 个人用户ID
     * 进件成功返回的个人用户 ID和二级商户 ID 选一填写
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "cusId长度不能超过19")
    private String cusId;

    /**
     * 二级商户ID
     * 进件成功返回的二级商户 ID和个人用户 ID 选一填写
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "mchId长度不能超过19")
    private String mchId;

    /**
     * 备注
     * 备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "remark长度不能超过255")
    private String remark;

}