/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.account;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 删除绑定账户入参
 *
 * @author
 * @version ShandeAccountDeleteBindingRequest.java, v 0.1 2022-12-06 13:42:24
 */
@Data
public class ShandeAccountDeleteBindingRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555190191401L;


    /**
     * 绑定账户编号
     * 系统生成的唯一编号银行账号和绑定账户编号二选一
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "settleAcctId长度不能超过19")
    private String settleAcctId;

    /**
     * 银行账号
     * 银行账号和绑定账户编号二选一
     *
     * (特殊必填)
     */
    @Length(max = 34, message = "bankAcctNo长度不能超过34")
    private String bankAcctNo;

    /**
     * 个人用户 ID
     * 当使用银行账号时个人用户 ID和二级商户 ID 选一填写
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "cusId长度不能超过19")
    private String cusId;

    /**
     * 二级商户 ID
     * 当使用银行账号时二级商户 ID和个人用户 ID 选一填写
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "mchId长度不能超过19")
    private String mchId;

}