package com.fshows.com.shande.openapi.sdk.crypto;

import com.fshows.com.shande.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fshows.com.shande.openapi.sdk.util.RSAUtils;

/**
 * RSA软验签策略,RSA加解密
 *
 * @author tangjunmao
 * @date 2018/10/22
 */
public class RSACryptoWithSoftwareStrategy extends RSACryptoEncryptionService implements CryptoSignatureService {

    @Override
    public String signature(String data,String privetKey) throws Exception {
        return RSAUtils.signature(data, privetKey);
    }

    @Override
    public boolean verifySignature(String data, String signature, String publicKey) throws Exception {
        return RSAUtils.verifySignature(data, signature, publicKey);
    }

    @Override
    public String getAlgorithmType() {
        return AlgorithmTypeEnum.RSA_SOFTWARE.getAlgorithmType();
    }
}
