package com.fshows.com.shande.openapi.sdk.constant;

/**
 * @author liangyuanping
 * @version RequestVerifyTypeEnum.java, v 0.1 2023-01-10 10:21 AM
 */
public enum RequestVerifyTypeEnum {

    ACCOUNT_OPENING("开户类", 1),
    OUT_FUND("出金类", 2),
    IN_FUND("入金类", 3);


    private String name;
    private Integer value;

    RequestVerifyTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }


    public static RequestVerifyTypeEnum getByValue(Integer value) {
        RequestVerifyTypeEnum[] valueList = RequestVerifyTypeEnum.values();
        for (RequestVerifyTypeEnum v : valueList) {
            if (v.value.equals(value)) {
                return v;
            }
        }
        return null;
    }


    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }

}