package com.fshows.com.shande.openapi.sdk.constant;

/**
 * 文件请求响应常量
 *
 * @author miwenming
 * @date 2020/5/25 16:17
 */
public class FileResponseConstants {
    /**
     * 响应头
     */
    public class ResponseHeader {
        public static final String KEY_BIZ_CONTENT = "biz_content";
    }

    /**
     * 文件下载响应码-成功
     */
    public static final String SUCCESS_CODE = "000000";

    /**
     * 响应头中的业务报文
     */
    public class BizContent {
        /**
         * 响应码
         */
        public static final String KEY_CODE = "code";

        /**
         * 响应消息
         */
        public static final String KEY_MESSAGE = "message";

        /** 签名数据 */
        public static final String KEY_SIGN_DATA = "sign_data";

        /** 签名结果 */
        public static final String KEY_SIGNATURE = "signature";
    }

    /**
     * 签名数据
     */
    public class SignData {
        /** 文件md5 */
        public static final String KEY_MD5 = "md5";

        /** 文件状态 */
        public static final String KEY_STATUS = "status";

        /** 文件类型 */
        public static final String KEY_FILE_TYPE = "file_type";

    }
}
