/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * 预授权完成撤销响应
 *
 * @author Cascade
 * @version PostarPreAuthFinishCancelRes.java, v 0.1 2025-12-08 14:50 Cascade
 */
@Data
public class PostarPreAuthFinishCancelRes extends PostarBizRes {
    private static final long serialVersionUID = 5839274598237459823L;

    /**
     * 平台订单号
     */
    private String orderFlowNo;

    /**
     * 原完成撤销第三方订单号
     */
    private String oldThreeNo;

    /**
     * 商户号
     */
    private String custId;

    /**
     * 完成撤销金额
     * 单位：分
     */
    private String amount;

    /**
     * 机构号
     */
    private String agetId;

    /**
     * 订单状态
     * 7撤销成功
     */
    private String orderStatus;

    /**
     * 完成撤销时间
     */
    private String orderTime;
}
