/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.customer;

import com.fshows.postar.response.PostarBizRes;
import com.fshows.postar.response.share.customer.detail.AttachmentInfoRes;
import com.fshows.postar.response.share.customer.detail.AuthSplitSettlementRes;
import com.fshows.postar.response.share.customer.detail.CustomerBaseInfoRes;
import com.fshows.postar.response.share.customer.detail.SplitSettlementRes;
import lombok.Data;

import java.util.List;

/**
 * 查询分账客户信息(XZY021)响应
 *
 * @author wangyi
 * @version PostarQuerySplitCustomerInfoRes.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarQuerySplitCustomerInfoRes extends PostarBizRes {

    /**
     * 客户基础信息
     */
    private CustomerBaseInfoRes customerBaseInfo;

    /**
     * 客户结算账户信息
     * 客户审核通过，已生效的结算信息
     */
    private List<SplitSettlementRes> splitSettlementList;

    /**
     * 结算卡审核信息
     */
    private List<AuthSplitSettlementRes> authSplitSettlementList;

    /**
     * 客户附件信息
     */
    private List<AttachmentInfoRes> attachmentList;
}
