/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.collect;

import com.fshows.postar.response.PostarBizRes;
import com.fshows.postar.response.share.collect.detail.AuthCollectSettlementRes;
import com.fshows.postar.response.share.collect.detail.CollectCustomerBaseInfoRes;
import com.fshows.postar.response.share.collect.detail.CollectSettlementRes;
import com.fshows.postar.response.share.customer.detail.AttachmentInfoRes;
import lombok.Data;

import java.util.List;

/**
 * 查询归集客户信息(XZY027)响应
 *
 * @author wangyi
 * @version PostarQueryCollectCustomerInfoRes.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarQueryCollectCustomerInfoRes extends PostarBizRes {

    /**
     * 客户基础信息
     */
    private CollectCustomerBaseInfoRes customerBaseInfo;

    /**
     * 客户结算账户信息
     * 客户审核通过，已生效的结算信息
     */
    private List<CollectSettlementRes> collectSettlementList;

    /**
     * 结算卡审核信息
     */
    private List<AuthCollectSettlementRes> authCollectSettlementList;

    /**
     * 客户附件信息
     */
    private List<AttachmentInfoRes> attachmentList;
}
