/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.merchant;

import lombok.Data;

import java.io.Serializable;

/**
 * @author weikunpeng
 * @version PostarReportNotifyRes.java, v 0.1 2024-10-10 09:21 weikunpeng
 */
@Data
public class PostarReportNotifyRes implements Serializable {


    private static final long serialVersionUID = 650501481716711338L;
    /**
     * 机构号
     * 必传字段
     */
    private String AGET_ID;

    /**
     * 商户号
     * 必传字段
     * 国通600商户号，用于接口文档内所有涉及商户号字段使用
     */
    private String CUST_ID;

    /**
     * 商户名称
     * 必传字段
     */
    private String BUS_NAME;

    /**
     * 支付通道
     * 可选字段
     * 示例：01银联微信、 02银联支付宝、 12收单刷卡、 13银联扫码（云闪付）
     */
    private String PAY_WAY;

    /**
     * 子商户号
     * 可选字段
     * 即对应支付通道的子商户号
     */
    private String MERCHNT_NO;

    /**
     * 通道报备状态
     * 可选字段
     * 00-初始 01-报备成功 02-报备失败
     */
    private String CHANEL_BAK_STATUS;

    /**
     * 收单刷卡实际报备状态
     * 可选字段
     * 00-初始 01-报备成功 02-报备失败 03-报备审核中
     */
    private String YL_BAK_STATUS;

    /**
     * 银联商户状态
     * 可选字段
     * 00-冻结 01-启用 02-注销
     */
    private String MERC_STATUS;

    /**
     * 报备时间
     * 可选字段
     * 格式：yyyy-mm-dd HH:mm:ss
     */
    private String BAK_TIME;

    /**
     * 报备结果描述
     * 可选字段
     * 根据实际返回进行通知
     */
    private String BAK_RESULT;

    /**
     * 签名
     * 必传字段
     */
    private String sign;

}