/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.trade;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version PostarUnionUserIdReq.java, v 0.1 2024-06-05 6:02 PM wangqilei
 */
@Data
public class PostarUnionUserIdReq extends PostarBaseReq {
    private static final long serialVersionUID = -8738286847103073327L;

    /**
     * 商户号
     * 商户所在国通系统内的商户号
     * (必填)
     */
    @NotBlank
    private String custId;

    /**
     * ip
     * (必填)
     */
    @NotBlank
    private String ip;

    /**
     * 支付标识
     * 收款方识别HTTP请求User Agent中包含银联支付标识， 格式为“ UnionPay/<版本号><App标识>”，
     * 其中<版本号>固定为1.0，<App标识>为付款方自行定义的内容（仅包含字母或数字）。
     * 示例：UnionPay/1.0 ICBCeLife
     * (必填)
     */
    @NotBlank
    private String payCode;

    /**
     * 授权码
     * 服付款方返回的临时授权码，一次有效。务商生成的订单号，合作方订单号，必填
     * (必填)
     */
    @NotBlank
    private String authCode;

    /**
     * 发起设备
     * 0：ANDROID sdk 1：IOS sdk 2：windows sdk 3: 直连
     * (必填)
     */
    @NotBlank
    private String access;

    /**
     * 接口请求时间. 格式yyyyMMddHHmmss
     */
    private String timeStamp;
}