/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.withdraw;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 提现(XZY036)请求
 *
 * @author wangyi
 * @version PostarWithdrawReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarWithdrawReq extends PostarBaseReq {

    /**
     * 管理员主商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 商户号600
     * 必填: 否
     */
    private String custId;

    /**
     * 客户号
     * 必填: 否
     */
    private String customerId;

    /**
     * 备注
     * 必填: 是
     */
    @NotBlank
    private String remark;

    /**
     * 三方订单号
     * 必填: 是
     */
    @NotBlank
    private String otherOrderNo;

    /**
     * 结算卡号，不传到账默认结算卡
     * 必填: 否
     */
    private String cardNo;

    /**
     * 提现金额：元
     * 必填: 是
     */
    @NotBlank
    private String withdrawalAmt;
}
